import pandas as pd  
import matplotlib.pyplot as plt  
import seaborn as sns  
from decision_company import read_csv_file, create_countplot, create_figure, set_plot_xlabel, create_figure, set_plot_title, set_yaxis_label, show_plots, save_plot

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")   
   
# Distribution plot for employment status  
create_figure((10, 6))  
create_countplot(data=credit_customers, x='employment', order=employment_counts.index)  
set_plot_title("Employment Status Distribution")  
set_plot_xlabel("Employment Status")  
set_yaxis_label("Frequency")  
save_plot('./ref_result/countplot.png')  
show_plots()  
